package zio.aws.workspacesweb.model
import scala.jdk.CollectionConverters.*
sealed trait AuthenticationType {
  def unwrap
      : software.amazon.awssdk.services.workspacesweb.model.AuthenticationType
}
object AuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.workspacesweb.model.AuthenticationType
  ): zio.aws.workspacesweb.model.AuthenticationType = value match {
    case software.amazon.awssdk.services.workspacesweb.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspacesweb.model.AuthenticationType.STANDARD =>
      val r = Standard
      r
    case software.amazon.awssdk.services.workspacesweb.model.AuthenticationType.IAM_IDENTITY_CENTER =>
      val r = IAM_Identity_Center
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspacesweb.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.AuthenticationType =
      software.amazon.awssdk.services.workspacesweb.model.AuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object Standard extends zio.aws.workspacesweb.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.AuthenticationType =
      software.amazon.awssdk.services.workspacesweb.model.AuthenticationType.STANDARD
  }
  case object IAM_Identity_Center
      extends zio.aws.workspacesweb.model.AuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.AuthenticationType =
      software.amazon.awssdk.services.workspacesweb.model.AuthenticationType.IAM_IDENTITY_CENTER
  }
}
