package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class AssociateUserAccessLoggingSettingsRequest(
    portalArn: ARN,
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest = {
    import AssociateUserAccessLoggingSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest
      .wrap(buildAwsValue())
}
object AssociateUserAccessLoggingSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest =
      zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest(
        portalArn,
        userAccessLoggingSettingsArn
      )
    def portalArn: ARN
    def userAccessLoggingSettingsArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest
  ) extends zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest
  ): zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
