package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class DeleteUserSettingsRequest(userSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest = {
    import DeleteUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest
      .builder()
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DeleteUserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DeleteUserSettingsRequest.wrap(buildAwsValue())
}
object DeleteUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.DeleteUserSettingsRequest =
      zio.aws.workspacesweb.model.DeleteUserSettingsRequest(userSettingsArn)
    def userSettingsArn: ARN
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest
  ) extends zio.aws.workspacesweb.model.DeleteUserSettingsRequest.ReadOnly {
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest
  ): zio.aws.workspacesweb.model.DeleteUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
