package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class AssociateUserAccessLoggingSettingsResponse(
    portalArn: ARN,
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse = {
    import AssociateUserAccessLoggingSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse
      .wrap(buildAwsValue())
}
object AssociateUserAccessLoggingSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse =
      zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse(
        portalArn,
        userAccessLoggingSettingsArn
      )
    def portalArn: ARN
    def userAccessLoggingSettingsArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse
  ) extends zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse
  ): zio.aws.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
