package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class AssociateBrowserSettingsRequest(
    browserSettingsArn: ARN,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest = {
    import AssociateBrowserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest
      .builder()
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateBrowserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.AssociateBrowserSettingsRequest
      .wrap(buildAwsValue())
}
object AssociateBrowserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateBrowserSettingsRequest =
      zio.aws.workspacesweb.model
        .AssociateBrowserSettingsRequest(browserSettingsArn, portalArn)
    def browserSettingsArn: ARN
    def portalArn: ARN
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest
  ) extends zio.aws.workspacesweb.model.AssociateBrowserSettingsRequest.ReadOnly {
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest
  ): zio.aws.workspacesweb.model.AssociateBrowserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
