package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.workspacesweb.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListTagsForResourceRequest =
      zio.aws.workspacesweb.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ARN
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest
  ) extends zio.aws.workspacesweb.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest
  ): zio.aws.workspacesweb.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
