package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class GetUserSettingsRequest(userSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest = {
    import GetUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest
      .builder()
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.GetUserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetUserSettingsRequest.wrap(buildAwsValue())
}
object GetUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetUserSettingsRequest =
      zio.aws.workspacesweb.model.GetUserSettingsRequest(userSettingsArn)
    def userSettingsArn: ARN
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest
  ) extends zio.aws.workspacesweb.model.GetUserSettingsRequest.ReadOnly {
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest
  ): zio.aws.workspacesweb.model.GetUserSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
