package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class GetBrowserSettingsRequest(browserSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest = {
    import GetBrowserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest
      .builder()
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetBrowserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetBrowserSettingsRequest.wrap(buildAwsValue())
}
object GetBrowserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetBrowserSettingsRequest =
      zio.aws.workspacesweb.model.GetBrowserSettingsRequest(browserSettingsArn)
    def browserSettingsArn: ARN
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest
  ) extends zio.aws.workspacesweb.model.GetBrowserSettingsRequest.ReadOnly {
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest
  ): zio.aws.workspacesweb.model.GetBrowserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
