package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class CreateUserAccessLoggingSettingsResponse(
    userAccessLoggingSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse = {
    import CreateUserAccessLoggingSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse
      .builder()
      .userAccessLoggingSettingsArn(
        ARN.unwrap(userAccessLoggingSettingsArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsResponse
      .wrap(buildAwsValue())
}
object CreateUserAccessLoggingSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsResponse =
      zio.aws.workspacesweb.model
        .CreateUserAccessLoggingSettingsResponse(userAccessLoggingSettingsArn)
    def userAccessLoggingSettingsArn: ARN
    def getUserAccessLoggingSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userAccessLoggingSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse
  ) extends zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsResponse.ReadOnly {
    override val userAccessLoggingSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives
        .ARN(impl.userAccessLoggingSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse
  ): zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
