package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{KinesisStreamArn, ClientToken}
import scala.jdk.CollectionConverters.*
final case class CreateUserAccessLoggingSettingsRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    kinesisStreamArn: KinesisStreamArn,
    tags: Optional[Iterable[zio.aws.workspacesweb.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest = {
    import CreateUserAccessLoggingSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .kinesisStreamArn(
        KinesisStreamArn.unwrap(kinesisStreamArn): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsRequest
      .wrap(buildAwsValue())
}
object CreateUserAccessLoggingSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsRequest =
      zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsRequest(
        clientToken.map(value => value),
        kinesisStreamArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[ClientToken]
    def kinesisStreamArn: KinesisStreamArn
    def tags: Optional[List[zio.aws.workspacesweb.model.Tag.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getKinesisStreamArn: ZIO[Any, Nothing, KinesisStreamArn] =
      ZIO.succeed(kinesisStreamArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest
  ) extends zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val kinesisStreamArn: KinesisStreamArn =
      zio.aws.workspacesweb.model.primitives
        .KinesisStreamArn(impl.kinesisStreamArn())
    override val tags
        : Optional[List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest
  ): zio.aws.workspacesweb.model.CreateUserAccessLoggingSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
