package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{ARN, DisplayName}
import scala.jdk.CollectionConverters.*
final case class UpdatePortalRequest(
    authenticationType: Optional[
      zio.aws.workspacesweb.model.AuthenticationType
    ] = Optional.Absent,
    displayName: Optional[DisplayName] = Optional.Absent,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest = {
    import UpdatePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
      .builder()
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UpdatePortalRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdatePortalRequest.wrap(buildAwsValue())
}
object UpdatePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdatePortalRequest =
      zio.aws.workspacesweb.model.UpdatePortalRequest(
        authenticationType.map(value => value),
        displayName.map(value => value),
        portalArn
      )
    def authenticationType
        : Optional[zio.aws.workspacesweb.model.AuthenticationType]
    def displayName: Optional[DisplayName]
    def portalArn: ARN
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
  ) extends zio.aws.workspacesweb.model.UpdatePortalRequest.ReadOnly {
    override val authenticationType
        : Optional[zio.aws.workspacesweb.model.AuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value =>
          zio.aws.workspacesweb.model.AuthenticationType.wrap(value)
        )
    override val displayName: Optional[DisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
  ): zio.aws.workspacesweb.model.UpdatePortalRequest.ReadOnly = new Wrapper(
    impl
  )
}
