package zio.aws.workspacesweb.model
import scala.jdk.CollectionConverters.*
sealed trait PortalStatus {
  def unwrap: software.amazon.awssdk.services.workspacesweb.model.PortalStatus
}
object PortalStatus {
  def wrap(
      value: software.amazon.awssdk.services.workspacesweb.model.PortalStatus
  ): zio.aws.workspacesweb.model.PortalStatus = value match {
    case software.amazon.awssdk.services.workspacesweb.model.PortalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspacesweb.model.PortalStatus.INCOMPLETE =>
      val r = Incomplete
      r
    case software.amazon.awssdk.services.workspacesweb.model.PortalStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.workspacesweb.model.PortalStatus.ACTIVE =>
      val r = Active
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspacesweb.model.PortalStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.PortalStatus =
      software.amazon.awssdk.services.workspacesweb.model.PortalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Incomplete extends zio.aws.workspacesweb.model.PortalStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.PortalStatus =
      software.amazon.awssdk.services.workspacesweb.model.PortalStatus.INCOMPLETE
  }
  case object Pending extends zio.aws.workspacesweb.model.PortalStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.PortalStatus =
      software.amazon.awssdk.services.workspacesweb.model.PortalStatus.PENDING
  }
  case object Active extends zio.aws.workspacesweb.model.PortalStatus {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.PortalStatus =
      software.amazon.awssdk.services.workspacesweb.model.PortalStatus.ACTIVE
  }
}
