package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class DisassociateUserAccessLoggingSettingsRequest(portalArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest = {
    import DisassociateUserAccessLoggingSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest
      .wrap(buildAwsValue())
}
object DisassociateUserAccessLoggingSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest =
      zio.aws.workspacesweb.model
        .DisassociateUserAccessLoggingSettingsRequest(portalArn)
    def portalArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest
  ) extends zio.aws.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest
  ): zio.aws.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
