package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class CreateBrowserSettingsResponse(browserSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse = {
    import CreateBrowserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse
      .builder()
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateBrowserSettingsResponse
      .wrap(buildAwsValue())
}
object CreateBrowserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateBrowserSettingsResponse =
      zio.aws.workspacesweb.model
        .CreateBrowserSettingsResponse(browserSettingsArn)
    def browserSettingsArn: ARN
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse
  ) extends zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly {
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse
  ): zio.aws.workspacesweb.model.CreateBrowserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
