package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{
  IdentityProviderName,
  StringType,
  ARN
}
import scala.jdk.CollectionConverters.*
final case class IdentityProvider(
    identityProviderArn: ARN,
    identityProviderDetails: Optional[Map[StringType, StringType]] =
      Optional.Absent,
    identityProviderName: Optional[IdentityProviderName] = Optional.Absent,
    identityProviderType: Optional[
      zio.aws.workspacesweb.model.IdentityProviderType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.IdentityProvider = {
    import IdentityProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.IdentityProvider
      .builder()
      .identityProviderArn(ARN.unwrap(identityProviderArn): java.lang.String)
      .optionallyWith(
        identityProviderDetails.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.identityProviderDetails)
      .optionallyWith(
        identityProviderName.map(value =>
          IdentityProviderName.unwrap(value): java.lang.String
        )
      )(_.identityProviderName)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.IdentityProvider.ReadOnly =
    zio.aws.workspacesweb.model.IdentityProvider.wrap(buildAwsValue())
}
object IdentityProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.IdentityProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.IdentityProvider =
      zio.aws.workspacesweb.model.IdentityProvider(
        identityProviderArn,
        identityProviderDetails.map(value => value),
        identityProviderName.map(value => value),
        identityProviderType.map(value => value)
      )
    def identityProviderArn: ARN
    def identityProviderDetails: Optional[Map[StringType, StringType]]
    def identityProviderName: Optional[IdentityProviderName]
    def identityProviderType
        : Optional[zio.aws.workspacesweb.model.IdentityProviderType]
    def getIdentityProviderArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(identityProviderArn)
    def getIdentityProviderDetails
        : ZIO[Any, AwsError, Map[StringType, StringType]] = AwsError
      .unwrapOptionField("identityProviderDetails", identityProviderDetails)
    def getIdentityProviderName: ZIO[Any, AwsError, IdentityProviderName] =
      AwsError.unwrapOptionField("identityProviderName", identityProviderName)
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.IdentityProvider
  ) extends zio.aws.workspacesweb.model.IdentityProvider.ReadOnly {
    override val identityProviderArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.identityProviderArn())
    override val identityProviderDetails
        : Optional[Map[StringType, StringType]] = zio.aws.core.internal
      .optionalFromNullable(impl.identityProviderDetails())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
    override val identityProviderName: Optional[IdentityProviderName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderName())
        .map(value =>
          zio.aws.workspacesweb.model.primitives.IdentityProviderName(value)
        )
    override val identityProviderType
        : Optional[zio.aws.workspacesweb.model.IdentityProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderType())
        .map(value =>
          zio.aws.workspacesweb.model.IdentityProviderType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.IdentityProvider
  ): zio.aws.workspacesweb.model.IdentityProvider.ReadOnly = new Wrapper(impl)
}
