package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class GetPortalServiceProviderMetadataRequest(portalArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest = {
    import GetPortalServiceProviderMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataRequest
      .wrap(buildAwsValue())
}
object GetPortalServiceProviderMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataRequest =
      zio.aws.workspacesweb.model
        .GetPortalServiceProviderMetadataRequest(portalArn)
    def portalArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest
  ) extends zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataRequest.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest
  ): zio.aws.workspacesweb.model.GetPortalServiceProviderMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
