package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListIdentityProvidersResponse(
    identityProviders: Optional[
      Iterable[zio.aws.workspacesweb.model.IdentityProviderSummary]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse = {
    import ListIdentityProvidersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse
      .builder()
      .optionallyWith(
        identityProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityProviders)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListIdentityProvidersResponse
      .wrap(buildAwsValue())
}
object ListIdentityProvidersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListIdentityProvidersResponse =
      zio.aws.workspacesweb.model.ListIdentityProvidersResponse(
        identityProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def identityProviders: Optional[
      List[zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getIdentityProviders: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("identityProviders", identityProviders)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse
  ) extends zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly {
    override val identityProviders: Optional[
      List[zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.identityProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.IdentityProviderSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse
  ): zio.aws.workspacesweb.model.ListIdentityProvidersResponse.ReadOnly =
    new Wrapper(impl)
}
