package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{ARN, ClientToken}
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    resourceArn: ARN,
    tags: Iterable[zio.aws.workspacesweb.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .resourceArn(ARN.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.TagResourceRequest.ReadOnly =
    zio.aws.workspacesweb.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.TagResourceRequest =
      zio.aws.workspacesweb.model.TagResourceRequest(
        clientToken.map(value => value),
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def clientToken: Optional[ClientToken]
    def resourceArn: ARN
    def tags: List[zio.aws.workspacesweb.model.Tag.ReadOnly]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getResourceArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest
  ) extends zio.aws.workspacesweb.model.TagResourceRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val resourceArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.resourceArn())
    override val tags: List[zio.aws.workspacesweb.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.workspacesweb.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest
  ): zio.aws.workspacesweb.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
