package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.{ARN, CertificateThumbprint}
import scala.jdk.CollectionConverters.*
final case class GetTrustStoreCertificateRequest(
    thumbprint: CertificateThumbprint,
    trustStoreArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest = {
    import GetTrustStoreCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest
      .builder()
      .thumbprint(CertificateThumbprint.unwrap(thumbprint): java.lang.String)
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetTrustStoreCertificateRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetTrustStoreCertificateRequest
      .wrap(buildAwsValue())
}
object GetTrustStoreCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.GetTrustStoreCertificateRequest =
      zio.aws.workspacesweb.model
        .GetTrustStoreCertificateRequest(thumbprint, trustStoreArn)
    def thumbprint: CertificateThumbprint
    def trustStoreArn: ARN
    def getThumbprint: ZIO[Any, Nothing, CertificateThumbprint] =
      ZIO.succeed(thumbprint)
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest
  ) extends zio.aws.workspacesweb.model.GetTrustStoreCertificateRequest.ReadOnly {
    override val thumbprint: CertificateThumbprint =
      zio.aws.workspacesweb.model.primitives
        .CertificateThumbprint(impl.thumbprint())
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest
  ): zio.aws.workspacesweb.model.GetTrustStoreCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
