package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{ARN, ClientToken}
import scala.jdk.CollectionConverters.*
final case class UpdateUserSettingsRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    copyAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    downloadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    pasteAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    printAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    uploadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType] =
      Optional.Absent,
    userSettingsArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest = {
    import UpdateUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(copyAllowed.map(value => value.unwrap))(_.copyAllowed)
      .optionallyWith(downloadAllowed.map(value => value.unwrap))(
        _.downloadAllowed
      )
      .optionallyWith(pasteAllowed.map(value => value.unwrap))(_.pasteAllowed)
      .optionallyWith(printAllowed.map(value => value.unwrap))(_.printAllowed)
      .optionallyWith(uploadAllowed.map(value => value.unwrap))(_.uploadAllowed)
      .userSettingsArn(ARN.unwrap(userSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateUserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateUserSettingsRequest.wrap(buildAwsValue())
}
object UpdateUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateUserSettingsRequest =
      zio.aws.workspacesweb.model.UpdateUserSettingsRequest(
        clientToken.map(value => value),
        copyAllowed.map(value => value),
        downloadAllowed.map(value => value),
        pasteAllowed.map(value => value),
        printAllowed.map(value => value),
        uploadAllowed.map(value => value),
        userSettingsArn
      )
    def clientToken: Optional[ClientToken]
    def copyAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def downloadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def pasteAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def printAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def uploadAllowed: Optional[zio.aws.workspacesweb.model.EnabledType]
    def userSettingsArn: ARN
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCopyAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("copyAllowed", copyAllowed)
    def getDownloadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("downloadAllowed", downloadAllowed)
    def getPasteAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("pasteAllowed", pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("printAllowed", printAllowed)
    def getUploadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("uploadAllowed", uploadAllowed)
    def getUserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
  ) extends zio.aws.workspacesweb.model.UpdateUserSettingsRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val copyAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val downloadAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.downloadAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val pasteAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pasteAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val printAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.printAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val uploadAllowed
        : Optional[zio.aws.workspacesweb.model.EnabledType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uploadAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val userSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.userSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest
  ): zio.aws.workspacesweb.model.UpdateUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
