package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.ClientToken
import scala.jdk.CollectionConverters.*
final case class CreateUserSettingsRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    copyAllowed: zio.aws.workspacesweb.model.EnabledType,
    downloadAllowed: zio.aws.workspacesweb.model.EnabledType,
    pasteAllowed: zio.aws.workspacesweb.model.EnabledType,
    printAllowed: zio.aws.workspacesweb.model.EnabledType,
    tags: Optional[Iterable[zio.aws.workspacesweb.model.Tag]] = Optional.Absent,
    uploadAllowed: zio.aws.workspacesweb.model.EnabledType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest = {
    import CreateUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .copyAllowed(copyAllowed.unwrap)
      .downloadAllowed(downloadAllowed.unwrap)
      .pasteAllowed(pasteAllowed.unwrap)
      .printAllowed(printAllowed.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .uploadAllowed(uploadAllowed.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateUserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreateUserSettingsRequest.wrap(buildAwsValue())
}
object CreateUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateUserSettingsRequest =
      zio.aws.workspacesweb.model.CreateUserSettingsRequest(
        clientToken.map(value => value),
        copyAllowed,
        downloadAllowed,
        pasteAllowed,
        printAllowed,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        uploadAllowed
      )
    def clientToken: Optional[ClientToken]
    def copyAllowed: zio.aws.workspacesweb.model.EnabledType
    def downloadAllowed: zio.aws.workspacesweb.model.EnabledType
    def pasteAllowed: zio.aws.workspacesweb.model.EnabledType
    def printAllowed: zio.aws.workspacesweb.model.EnabledType
    def tags: Optional[List[zio.aws.workspacesweb.model.Tag.ReadOnly]]
    def uploadAllowed: zio.aws.workspacesweb.model.EnabledType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCopyAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(copyAllowed)
    def getDownloadAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(downloadAllowed)
    def getPasteAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(printAllowed)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUploadAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(uploadAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
  ) extends zio.aws.workspacesweb.model.CreateUserSettingsRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val copyAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.copyAllowed())
    override val downloadAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.downloadAllowed())
    override val pasteAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.pasteAllowed())
    override val printAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.printAllowed())
    override val tags
        : Optional[List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.Tag.wrap(item)
          }.toList
        )
    override val uploadAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.uploadAllowed())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
  ): zio.aws.workspacesweb.model.CreateUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
