package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListUserSettingsResponse(
    nextToken: Option[PaginationToken] = None,
    userSettings: Option[
      Iterable[zio.aws.workspacesweb.model.UserSettingsSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse = {
    import ListUserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        userSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userSettings)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListUserSettingsResponse.wrap(buildAwsValue())
}
object ListUserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListUserSettingsResponse =
      zio.aws.workspacesweb.model.ListUserSettingsResponse(
        nextToken.map(value => value),
        userSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[PaginationToken]
    def userSettings
        : Option[List[zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getUserSettings: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("userSettings", userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse
  ) extends zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
    override val userSettings: Option[
      List[zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly]
    ] = scala
      .Option(impl.userSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.UserSettingsSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse
  ): zio.aws.workspacesweb.model.ListUserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
