package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class DeleteBrowserSettingsRequest(browserSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest = {
    import DeleteBrowserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest
      .builder()
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.DeleteBrowserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.DeleteBrowserSettingsRequest
      .wrap(buildAwsValue())
}
object DeleteBrowserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.DeleteBrowserSettingsRequest =
      zio.aws.workspacesweb.model
        .DeleteBrowserSettingsRequest(browserSettingsArn)
    def browserSettingsArn: ARN
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest
  ) extends zio.aws.workspacesweb.model.DeleteBrowserSettingsRequest.ReadOnly {
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest
  ): zio.aws.workspacesweb.model.DeleteBrowserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
