package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class AssociateBrowserSettingsResponse(
    browserSettingsArn: ARN,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse = {
    import AssociateBrowserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse
      .builder()
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse
      .wrap(buildAwsValue())
}
object AssociateBrowserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse =
      zio.aws.workspacesweb.model
        .AssociateBrowserSettingsResponse(browserSettingsArn, portalArn)
    def browserSettingsArn: ARN
    def portalArn: ARN
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse
  ) extends zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly {
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse
  ): zio.aws.workspacesweb.model.AssociateBrowserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
