package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{ClientToken, ARN, BrowserPolicy}
import scala.jdk.CollectionConverters.*
final case class UpdateBrowserSettingsRequest(
    browserPolicy: Option[BrowserPolicy] = None,
    browserSettingsArn: ARN,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest = {
    import UpdateBrowserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest
      .builder()
      .optionallyWith(
        browserPolicy.map(value =>
          BrowserPolicy.unwrap(value): java.lang.String
        )
      )(_.browserPolicy)
      .browserSettingsArn(ARN.unwrap(browserSettingsArn): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.UpdateBrowserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdateBrowserSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateBrowserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdateBrowserSettingsRequest =
      zio.aws.workspacesweb.model.UpdateBrowserSettingsRequest(
        browserPolicy.map(value => value),
        browserSettingsArn,
        clientToken.map(value => value)
      )
    def browserPolicy: Option[BrowserPolicy]
    def browserSettingsArn: ARN
    def clientToken: Option[ClientToken]
    def getBrowserPolicy: ZIO[Any, AwsError, BrowserPolicy] =
      AwsError.unwrapOptionField("browserPolicy", browserPolicy)
    def getBrowserSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(browserSettingsArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest
  ) extends zio.aws.workspacesweb.model.UpdateBrowserSettingsRequest.ReadOnly {
    override val browserPolicy: Option[BrowserPolicy] = scala
      .Option(impl.browserPolicy())
      .map(value => zio.aws.workspacesweb.model.primitives.BrowserPolicy(value))
    override val browserSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.browserSettingsArn())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest
  ): zio.aws.workspacesweb.model.UpdateBrowserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
