package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{ARN, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class ListTrustStoreCertificatesResponse(
    certificateList: Option[
      Iterable[zio.aws.workspacesweb.model.CertificateSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None,
    trustStoreArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse = {
    import ListTrustStoreCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse
      .builder()
      .optionallyWith(
        certificateList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificateList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        trustStoreArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.trustStoreArn)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse
      .wrap(buildAwsValue())
}
object ListTrustStoreCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse =
      zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse(
        certificateList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        trustStoreArn.map(value => value)
      )
    def certificateList
        : Option[List[zio.aws.workspacesweb.model.CertificateSummary.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def trustStoreArn: Option[ARN]
    def getCertificateList: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.CertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("certificateList", certificateList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrustStoreArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("trustStoreArn", trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse
  ) extends zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly {
    override val certificateList: Option[
      List[zio.aws.workspacesweb.model.CertificateSummary.ReadOnly]
    ] = scala
      .Option(impl.certificateList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.CertificateSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
    override val trustStoreArn: Option[ARN] = scala
      .Option(impl.trustStoreArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse
  ): zio.aws.workspacesweb.model.ListTrustStoreCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
