package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetNetworkSettingsResponse(
    networkSettings: Option[zio.aws.workspacesweb.model.NetworkSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse = {
    import GetNetworkSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse
      .builder()
      .optionallyWith(networkSettings.map(value => value.buildAwsValue()))(
        _.networkSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetNetworkSettingsResponse.wrap(buildAwsValue())
}
object GetNetworkSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetNetworkSettingsResponse =
      zio.aws.workspacesweb.model.GetNetworkSettingsResponse(
        networkSettings.map(value => value.asEditable)
      )
    def networkSettings
        : Option[zio.aws.workspacesweb.model.NetworkSettings.ReadOnly]
    def getNetworkSettings: ZIO[
      Any,
      AwsError,
      zio.aws.workspacesweb.model.NetworkSettings.ReadOnly
    ] = AwsError.unwrapOptionField("networkSettings", networkSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse
  ) extends zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly {
    override val networkSettings
        : Option[zio.aws.workspacesweb.model.NetworkSettings.ReadOnly] = scala
      .Option(impl.networkSettings())
      .map(value => zio.aws.workspacesweb.model.NetworkSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse
  ): zio.aws.workspacesweb.model.GetNetworkSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
