package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class GetNetworkSettingsRequest(networkSettingsArn: ARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest = {
    import GetNetworkSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest
      .builder()
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetNetworkSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.GetNetworkSettingsRequest.wrap(buildAwsValue())
}
object GetNetworkSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetNetworkSettingsRequest =
      zio.aws.workspacesweb.model.GetNetworkSettingsRequest(networkSettingsArn)
    def networkSettingsArn: ARN
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest
  ) extends zio.aws.workspacesweb.model.GetNetworkSettingsRequest.ReadOnly {
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest
  ): zio.aws.workspacesweb.model.GetNetworkSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
