package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  ARN,
  IdentityProviderName,
  StringType,
  ClientToken
}
import scala.jdk.CollectionConverters.*
final case class CreateIdentityProviderRequest(
    clientToken: Option[ClientToken] = None,
    identityProviderDetails: Map[StringType, StringType],
    identityProviderName: IdentityProviderName,
    identityProviderType: zio.aws.workspacesweb.model.IdentityProviderType,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest = {
    import CreateIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .identityProviderDetails(
        identityProviderDetails
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .identityProviderName(
        IdentityProviderName.unwrap(identityProviderName): java.lang.String
      )
      .identityProviderType(identityProviderType.unwrap)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateIdentityProviderRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreateIdentityProviderRequest
      .wrap(buildAwsValue())
}
object CreateIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateIdentityProviderRequest =
      zio.aws.workspacesweb.model.CreateIdentityProviderRequest(
        clientToken.map(value => value),
        identityProviderDetails,
        identityProviderName,
        identityProviderType,
        portalArn
      )
    def clientToken: Option[ClientToken]
    def identityProviderDetails: Map[StringType, StringType]
    def identityProviderName: IdentityProviderName
    def identityProviderType: zio.aws.workspacesweb.model.IdentityProviderType
    def portalArn: ARN
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getIdentityProviderDetails
        : ZIO[Any, Nothing, Map[StringType, StringType]] =
      ZIO.succeed(identityProviderDetails)
    def getIdentityProviderName: ZIO[Any, Nothing, IdentityProviderName] =
      ZIO.succeed(identityProviderName)
    def getIdentityProviderType
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.IdentityProviderType] =
      ZIO.succeed(identityProviderType)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest
  ) extends zio.aws.workspacesweb.model.CreateIdentityProviderRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val identityProviderDetails: Map[StringType, StringType] = impl
      .identityProviderDetails()
      .asScala
      .map({ case (key, value) =>
        (key: StringType) -> (value: StringType)
      })
      .toMap
    override val identityProviderName: IdentityProviderName =
      zio.aws.workspacesweb.model.primitives
        .IdentityProviderName(impl.identityProviderName())
    override val identityProviderType
        : zio.aws.workspacesweb.model.IdentityProviderType =
      zio.aws.workspacesweb.model.IdentityProviderType
        .wrap(impl.identityProviderType())
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest
  ): zio.aws.workspacesweb.model.CreateIdentityProviderRequest.ReadOnly =
    new Wrapper(impl)
}
