package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  KeyArn,
  ClientToken,
  BrowserPolicy,
  StringType
}
import scala.jdk.CollectionConverters.*
final case class CreateBrowserSettingsRequest(
    additionalEncryptionContext: Option[Map[StringType, StringType]] = None,
    browserPolicy: BrowserPolicy,
    clientToken: Option[ClientToken] = None,
    customerManagedKey: Option[KeyArn] = None,
    tags: Option[Iterable[zio.aws.workspacesweb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest = {
    import CreateBrowserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest
      .builder()
      .optionallyWith(
        additionalEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalEncryptionContext)
      .browserPolicy(BrowserPolicy.unwrap(browserPolicy): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        customerManagedKey.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.customerManagedKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateBrowserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreateBrowserSettingsRequest
      .wrap(buildAwsValue())
}
object CreateBrowserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateBrowserSettingsRequest =
      zio.aws.workspacesweb.model.CreateBrowserSettingsRequest(
        additionalEncryptionContext.map(value => value),
        browserPolicy,
        clientToken.map(value => value),
        customerManagedKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def additionalEncryptionContext: Option[Map[StringType, StringType]]
    def browserPolicy: BrowserPolicy
    def clientToken: Option[ClientToken]
    def customerManagedKey: Option[KeyArn]
    def tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]]
    def getAdditionalEncryptionContext
        : ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField(
        "additionalEncryptionContext",
        additionalEncryptionContext
      )
    def getBrowserPolicy: ZIO[Any, Nothing, BrowserPolicy] =
      ZIO.succeed(browserPolicy)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCustomerManagedKey: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("customerManagedKey", customerManagedKey)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest
  ) extends zio.aws.workspacesweb.model.CreateBrowserSettingsRequest.ReadOnly {
    override val additionalEncryptionContext
        : Option[Map[StringType, StringType]] = scala
      .Option(impl.additionalEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
    override val browserPolicy: BrowserPolicy =
      zio.aws.workspacesweb.model.primitives.BrowserPolicy(impl.browserPolicy())
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val customerManagedKey: Option[KeyArn] = scala
      .Option(impl.customerManagedKey())
      .map(value => zio.aws.workspacesweb.model.primitives.KeyArn(value))
    override val tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest
  ): zio.aws.workspacesweb.model.CreateBrowserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
