package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{IdentityProviderName, ARN}
import scala.jdk.CollectionConverters.*
final case class IdentityProviderSummary(
    identityProviderArn: Option[ARN] = None,
    identityProviderName: Option[IdentityProviderName] = None,
    identityProviderType: Option[
      zio.aws.workspacesweb.model.IdentityProviderType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary = {
    import IdentityProviderSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
      .builder()
      .optionallyWith(
        identityProviderArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.identityProviderArn)
      .optionallyWith(
        identityProviderName.map(value =>
          IdentityProviderName.unwrap(value): java.lang.String
        )
      )(_.identityProviderName)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly =
    zio.aws.workspacesweb.model.IdentityProviderSummary.wrap(buildAwsValue())
}
object IdentityProviderSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.IdentityProviderSummary =
      zio.aws.workspacesweb.model.IdentityProviderSummary(
        identityProviderArn.map(value => value),
        identityProviderName.map(value => value),
        identityProviderType.map(value => value)
      )
    def identityProviderArn: Option[ARN]
    def identityProviderName: Option[IdentityProviderName]
    def identityProviderType
        : Option[zio.aws.workspacesweb.model.IdentityProviderType]
    def getIdentityProviderArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("identityProviderArn", identityProviderArn)
    def getIdentityProviderName: ZIO[Any, AwsError, IdentityProviderName] =
      AwsError.unwrapOptionField("identityProviderName", identityProviderName)
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
  ) extends zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly {
    override val identityProviderArn: Option[ARN] = scala
      .Option(impl.identityProviderArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val identityProviderName: Option[IdentityProviderName] = scala
      .Option(impl.identityProviderName())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.IdentityProviderName(value)
      )
    override val identityProviderType
        : Option[zio.aws.workspacesweb.model.IdentityProviderType] = scala
      .Option(impl.identityProviderType())
      .map(value =>
        zio.aws.workspacesweb.model.IdentityProviderType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.IdentityProviderSummary
  ): zio.aws.workspacesweb.model.IdentityProviderSummary.ReadOnly = new Wrapper(
    impl
  )
}
