package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  DisplayName,
  KeyArn,
  ClientToken,
  StringType
}
import scala.jdk.CollectionConverters.*
final case class CreatePortalRequest(
    additionalEncryptionContext: Option[Map[StringType, StringType]] = None,
    clientToken: Option[ClientToken] = None,
    customerManagedKey: Option[KeyArn] = None,
    displayName: Option[DisplayName] = None,
    tags: Option[Iterable[zio.aws.workspacesweb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest = {
    import CreatePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest
      .builder()
      .optionallyWith(
        additionalEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (StringType.unwrap(key): java.lang.String) -> (StringType.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.additionalEncryptionContext)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        customerManagedKey.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.customerManagedKey)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.CreatePortalRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreatePortalRequest.wrap(buildAwsValue())
}
object CreatePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreatePortalRequest =
      zio.aws.workspacesweb.model.CreatePortalRequest(
        additionalEncryptionContext.map(value => value),
        clientToken.map(value => value),
        customerManagedKey.map(value => value),
        displayName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def additionalEncryptionContext: Option[Map[StringType, StringType]]
    def clientToken: Option[ClientToken]
    def customerManagedKey: Option[KeyArn]
    def displayName: Option[DisplayName]
    def tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]]
    def getAdditionalEncryptionContext
        : ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField(
        "additionalEncryptionContext",
        additionalEncryptionContext
      )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCustomerManagedKey: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("customerManagedKey", customerManagedKey)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest
  ) extends zio.aws.workspacesweb.model.CreatePortalRequest.ReadOnly {
    override val additionalEncryptionContext
        : Option[Map[StringType, StringType]] = scala
      .Option(impl.additionalEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.workspacesweb.model.primitives.StringType(
              key
            ) -> zio.aws.workspacesweb.model.primitives.StringType(value)
          })
          .toMap
      )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val customerManagedKey: Option[KeyArn] = scala
      .Option(impl.customerManagedKey())
      .map(value => zio.aws.workspacesweb.model.primitives.KeyArn(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest
  ): zio.aws.workspacesweb.model.CreatePortalRequest.ReadOnly = new Wrapper(
    impl
  )
}
