package zio.aws.workspacesweb.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{ARN, PaginationToken, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListTrustStoreCertificatesRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[PaginationToken] = None,
    trustStoreArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest = {
    import ListTrustStoreCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListTrustStoreCertificatesRequest.ReadOnly =
    zio.aws.workspacesweb.model.ListTrustStoreCertificatesRequest
      .wrap(buildAwsValue())
}
object ListTrustStoreCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.ListTrustStoreCertificatesRequest =
      zio.aws.workspacesweb.model.ListTrustStoreCertificatesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        trustStoreArn
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[PaginationToken]
    def trustStoreArn: ARN
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest
  ) extends zio.aws.workspacesweb.model.ListTrustStoreCertificatesRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.workspacesweb.model.primitives.MaxResults(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest
  ): zio.aws.workspacesweb.model.ListTrustStoreCertificatesRequest.ReadOnly =
    new Wrapper(impl)
}
