package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPortalResponse(
    portal: Option[zio.aws.workspacesweb.model.Portal] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse = {
    import GetPortalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse
      .builder()
      .optionallyWith(portal.map(value => value.buildAwsValue()))(_.portal)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetPortalResponse.wrap(buildAwsValue())
}
object GetPortalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetPortalResponse =
      zio.aws.workspacesweb.model
        .GetPortalResponse(portal.map(value => value.asEditable))
    def portal: Option[zio.aws.workspacesweb.model.Portal.ReadOnly]
    def getPortal
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.Portal.ReadOnly] =
      AwsError.unwrapOptionField("portal", portal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse
  ) extends zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly {
    override val portal: Option[zio.aws.workspacesweb.model.Portal.ReadOnly] =
      scala
        .Option(impl.portal())
        .map(value => zio.aws.workspacesweb.model.Portal.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse
  ): zio.aws.workspacesweb.model.GetPortalResponse.ReadOnly = new Wrapper(impl)
}
