package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class AssociateNetworkSettingsResponse(
    networkSettingsArn: ARN,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse = {
    import AssociateNetworkSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse
      .builder()
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse
      .wrap(buildAwsValue())
}
object AssociateNetworkSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse =
      zio.aws.workspacesweb.model
        .AssociateNetworkSettingsResponse(networkSettingsArn, portalArn)
    def networkSettingsArn: ARN
    def portalArn: ARN
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse
  ) extends zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse.ReadOnly {
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse
  ): zio.aws.workspacesweb.model.AssociateNetworkSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
