package zio.aws.workspacesweb.model
import scala.jdk.CollectionConverters.*
sealed trait EnabledType {
  def unwrap: software.amazon.awssdk.services.workspacesweb.model.EnabledType
}
object EnabledType {
  def wrap(
      value: software.amazon.awssdk.services.workspacesweb.model.EnabledType
  ): zio.aws.workspacesweb.model.EnabledType = value match {
    case software.amazon.awssdk.services.workspacesweb.model.EnabledType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspacesweb.model.EnabledType.DISABLED =>
      val r = Disabled
      r
    case software.amazon.awssdk.services.workspacesweb.model.EnabledType.ENABLED =>
      val r = Enabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspacesweb.model.EnabledType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.EnabledType =
      software.amazon.awssdk.services.workspacesweb.model.EnabledType.UNKNOWN_TO_SDK_VERSION
  }
  case object Disabled extends zio.aws.workspacesweb.model.EnabledType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.EnabledType =
      software.amazon.awssdk.services.workspacesweb.model.EnabledType.DISABLED
  }
  case object Enabled extends zio.aws.workspacesweb.model.EnabledType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.EnabledType =
      software.amazon.awssdk.services.workspacesweb.model.EnabledType.ENABLED
  }
}
