package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class AssociateTrustStoreResponse(
    portalArn: ARN,
    trustStoreArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse = {
    import AssociateTrustStoreResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse
      .builder()
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .trustStoreArn(ARN.unwrap(trustStoreArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly =
    zio.aws.workspacesweb.model.AssociateTrustStoreResponse
      .wrap(buildAwsValue())
}
object AssociateTrustStoreResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.AssociateTrustStoreResponse =
      zio.aws.workspacesweb.model
        .AssociateTrustStoreResponse(portalArn, trustStoreArn)
    def portalArn: ARN
    def trustStoreArn: ARN
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
    def getTrustStoreArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(trustStoreArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse
  ) extends zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly {
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
    override val trustStoreArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.trustStoreArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse
  ): zio.aws.workspacesweb.model.AssociateTrustStoreResponse.ReadOnly =
    new Wrapper(impl)
}
