package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.ARN
import scala.jdk.CollectionConverters.*
final case class UserSettingsSummary(
    copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    downloadAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    printAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    uploadAllowed: Option[zio.aws.workspacesweb.model.EnabledType] = None,
    userSettingsArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary = {
    import UserSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
      .builder()
      .optionallyWith(copyAllowed.map(value => value.unwrap))(_.copyAllowed)
      .optionallyWith(downloadAllowed.map(value => value.unwrap))(
        _.downloadAllowed
      )
      .optionallyWith(pasteAllowed.map(value => value.unwrap))(_.pasteAllowed)
      .optionallyWith(printAllowed.map(value => value.unwrap))(_.printAllowed)
      .optionallyWith(uploadAllowed.map(value => value.unwrap))(_.uploadAllowed)
      .optionallyWith(
        userSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.userSettingsArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.UserSettingsSummary.wrap(buildAwsValue())
}
object UserSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UserSettingsSummary =
      zio.aws.workspacesweb.model.UserSettingsSummary(
        copyAllowed.map(value => value),
        downloadAllowed.map(value => value),
        pasteAllowed.map(value => value),
        printAllowed.map(value => value),
        uploadAllowed.map(value => value),
        userSettingsArn.map(value => value)
      )
    def copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def downloadAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def printAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def uploadAllowed: Option[zio.aws.workspacesweb.model.EnabledType]
    def userSettingsArn: Option[ARN]
    def getCopyAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("copyAllowed", copyAllowed)
    def getDownloadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("downloadAllowed", downloadAllowed)
    def getPasteAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("pasteAllowed", pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("printAllowed", printAllowed)
    def getUploadAllowed
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.EnabledType] =
      AwsError.unwrapOptionField("uploadAllowed", uploadAllowed)
    def getUserSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("userSettingsArn", userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
  ) extends zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly {
    override val copyAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.copyAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val downloadAllowed
        : Option[zio.aws.workspacesweb.model.EnabledType] = scala
      .Option(impl.downloadAllowed())
      .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val pasteAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.pasteAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val printAllowed: Option[zio.aws.workspacesweb.model.EnabledType] =
      scala
        .Option(impl.printAllowed())
        .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val uploadAllowed
        : Option[zio.aws.workspacesweb.model.EnabledType] = scala
      .Option(impl.uploadAllowed())
      .map(value => zio.aws.workspacesweb.model.EnabledType.wrap(value))
    override val userSettingsArn: Option[ARN] = scala
      .Option(impl.userSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary
  ): zio.aws.workspacesweb.model.UserSettingsSummary.ReadOnly = new Wrapper(
    impl
  )
}
