package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdatePortalResponse(
    portal: Option[zio.aws.workspacesweb.model.Portal] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse = {
    import UpdatePortalResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse
      .builder()
      .optionallyWith(portal.map(value => value.buildAwsValue()))(_.portal)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly =
    zio.aws.workspacesweb.model.UpdatePortalResponse.wrap(buildAwsValue())
}
object UpdatePortalResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdatePortalResponse =
      zio.aws.workspacesweb.model
        .UpdatePortalResponse(portal.map(value => value.asEditable))
    def portal: Option[zio.aws.workspacesweb.model.Portal.ReadOnly]
    def getPortal
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.Portal.ReadOnly] =
      AwsError.unwrapOptionField("portal", portal)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse
  ) extends zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly {
    override val portal: Option[zio.aws.workspacesweb.model.Portal.ReadOnly] =
      scala
        .Option(impl.portal())
        .map(value => zio.aws.workspacesweb.model.Portal.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse
  ): zio.aws.workspacesweb.model.UpdatePortalResponse.ReadOnly = new Wrapper(
    impl
  )
}
