package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{ARN, DisplayName}
import scala.jdk.CollectionConverters.*
final case class UpdatePortalRequest(
    displayName: Option[DisplayName] = None,
    portalArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest = {
    import UpdatePortalRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
      .builder()
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .portalArn(ARN.unwrap(portalArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.UpdatePortalRequest.ReadOnly =
    zio.aws.workspacesweb.model.UpdatePortalRequest.wrap(buildAwsValue())
}
object UpdatePortalRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.UpdatePortalRequest =
      zio.aws.workspacesweb.model
        .UpdatePortalRequest(displayName.map(value => value), portalArn)
    def displayName: Option[DisplayName]
    def portalArn: ARN
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getPortalArn: ZIO[Any, Nothing, ARN] = ZIO.succeed(portalArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
  ) extends zio.aws.workspacesweb.model.UpdatePortalRequest.ReadOnly {
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val portalArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.portalArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest
  ): zio.aws.workspacesweb.model.UpdatePortalRequest.ReadOnly = new Wrapper(
    impl
  )
}
