package zio.aws.workspacesweb.model
import scala.jdk.CollectionConverters.*
sealed trait IdentityProviderType {
  def unwrap
      : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType
}
object IdentityProviderType {
  def wrap(
      value: software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType
  ): zio.aws.workspacesweb.model.IdentityProviderType = value match {
    case software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.SAML =>
      val r = SAML
      r
    case software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.FACEBOOK =>
      val r = Facebook
      r
    case software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.GOOGLE =>
      val r = Google
      r
    case software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.LOGIN_WITH_AMAZON =>
      val r = LoginWithAmazon
      r
    case software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.SIGN_IN_WITH_APPLE =>
      val r = SignInWithApple
      r
    case software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.OIDC =>
      val r = OIDC
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workspacesweb.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType =
      software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.UNKNOWN_TO_SDK_VERSION
  }
  case object SAML extends zio.aws.workspacesweb.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType =
      software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.SAML
  }
  case object Facebook
      extends zio.aws.workspacesweb.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType =
      software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.FACEBOOK
  }
  case object Google extends zio.aws.workspacesweb.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType =
      software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.GOOGLE
  }
  case object LoginWithAmazon
      extends zio.aws.workspacesweb.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType =
      software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.LOGIN_WITH_AMAZON
  }
  case object SignInWithApple
      extends zio.aws.workspacesweb.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType =
      software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.SIGN_IN_WITH_APPLE
  }
  case object OIDC extends zio.aws.workspacesweb.model.IdentityProviderType {
    override def unwrap
        : software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType =
      software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType.OIDC
  }
}
