package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workspacesweb.model.primitives.{
  DisplayName,
  StatusReason,
  Timestamp,
  PortalEndpoint,
  ARN
}
import scala.jdk.CollectionConverters.*
final case class Portal(
    browserSettingsArn: Option[ARN] = None,
    browserType: Option[zio.aws.workspacesweb.model.BrowserType] = None,
    creationDate: Option[Timestamp] = None,
    displayName: Option[DisplayName] = None,
    networkSettingsArn: Option[ARN] = None,
    portalArn: Option[ARN] = None,
    portalEndpoint: Option[PortalEndpoint] = None,
    portalStatus: Option[zio.aws.workspacesweb.model.PortalStatus] = None,
    rendererType: Option[zio.aws.workspacesweb.model.RendererType] = None,
    statusReason: Option[StatusReason] = None,
    trustStoreArn: Option[ARN] = None,
    userSettingsArn: Option[ARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.Portal = {
    import Portal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.Portal
      .builder()
      .optionallyWith(
        browserSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.browserSettingsArn)
      .optionallyWith(browserType.map(value => value.unwrap))(_.browserType)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        displayName.map(value => DisplayName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(
        networkSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.networkSettingsArn)
      .optionallyWith(
        portalArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.portalArn)
      .optionallyWith(
        portalEndpoint.map(value =>
          PortalEndpoint.unwrap(value): java.lang.String
        )
      )(_.portalEndpoint)
      .optionallyWith(portalStatus.map(value => value.unwrap))(_.portalStatus)
      .optionallyWith(rendererType.map(value => value.unwrap))(_.rendererType)
      .optionallyWith(
        statusReason.map(value => StatusReason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        trustStoreArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.trustStoreArn)
      .optionallyWith(
        userSettingsArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.userSettingsArn)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.Portal.ReadOnly =
    zio.aws.workspacesweb.model.Portal.wrap(buildAwsValue())
}
object Portal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.Portal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.Portal =
      zio.aws.workspacesweb.model.Portal(
        browserSettingsArn.map(value => value),
        browserType.map(value => value),
        creationDate.map(value => value),
        displayName.map(value => value),
        networkSettingsArn.map(value => value),
        portalArn.map(value => value),
        portalEndpoint.map(value => value),
        portalStatus.map(value => value),
        rendererType.map(value => value),
        statusReason.map(value => value),
        trustStoreArn.map(value => value),
        userSettingsArn.map(value => value)
      )
    def browserSettingsArn: Option[ARN]
    def browserType: Option[zio.aws.workspacesweb.model.BrowserType]
    def creationDate: Option[Timestamp]
    def displayName: Option[DisplayName]
    def networkSettingsArn: Option[ARN]
    def portalArn: Option[ARN]
    def portalEndpoint: Option[PortalEndpoint]
    def portalStatus: Option[zio.aws.workspacesweb.model.PortalStatus]
    def rendererType: Option[zio.aws.workspacesweb.model.RendererType]
    def statusReason: Option[StatusReason]
    def trustStoreArn: Option[ARN]
    def userSettingsArn: Option[ARN]
    def getBrowserSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("browserSettingsArn", browserSettingsArn)
    def getBrowserType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.BrowserType] =
      AwsError.unwrapOptionField("browserType", browserType)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getDisplayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getNetworkSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("networkSettingsArn", networkSettingsArn)
    def getPortalArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("portalArn", portalArn)
    def getPortalEndpoint: ZIO[Any, AwsError, PortalEndpoint] =
      AwsError.unwrapOptionField("portalEndpoint", portalEndpoint)
    def getPortalStatus
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.PortalStatus] =
      AwsError.unwrapOptionField("portalStatus", portalStatus)
    def getRendererType
        : ZIO[Any, AwsError, zio.aws.workspacesweb.model.RendererType] =
      AwsError.unwrapOptionField("rendererType", rendererType)
    def getStatusReason: ZIO[Any, AwsError, StatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getTrustStoreArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("trustStoreArn", trustStoreArn)
    def getUserSettingsArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("userSettingsArn", userSettingsArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.Portal
  ) extends zio.aws.workspacesweb.model.Portal.ReadOnly {
    override val browserSettingsArn: Option[ARN] = scala
      .Option(impl.browserSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val browserType: Option[zio.aws.workspacesweb.model.BrowserType] =
      scala
        .Option(impl.browserType())
        .map(value => zio.aws.workspacesweb.model.BrowserType.wrap(value))
    override val creationDate: Option[Timestamp] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.workspacesweb.model.primitives.Timestamp(value))
    override val displayName: Option[DisplayName] = scala
      .Option(impl.displayName())
      .map(value => zio.aws.workspacesweb.model.primitives.DisplayName(value))
    override val networkSettingsArn: Option[ARN] = scala
      .Option(impl.networkSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val portalArn: Option[ARN] = scala
      .Option(impl.portalArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val portalEndpoint: Option[PortalEndpoint] = scala
      .Option(impl.portalEndpoint())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PortalEndpoint(value)
      )
    override val portalStatus
        : Option[zio.aws.workspacesweb.model.PortalStatus] = scala
      .Option(impl.portalStatus())
      .map(value => zio.aws.workspacesweb.model.PortalStatus.wrap(value))
    override val rendererType
        : Option[zio.aws.workspacesweb.model.RendererType] = scala
      .Option(impl.rendererType())
      .map(value => zio.aws.workspacesweb.model.RendererType.wrap(value))
    override val statusReason: Option[StatusReason] = scala
      .Option(impl.statusReason())
      .map(value => zio.aws.workspacesweb.model.primitives.StatusReason(value))
    override val trustStoreArn: Option[ARN] = scala
      .Option(impl.trustStoreArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
    override val userSettingsArn: Option[ARN] = scala
      .Option(impl.userSettingsArn())
      .map(value => zio.aws.workspacesweb.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.Portal
  ): zio.aws.workspacesweb.model.Portal.ReadOnly = new Wrapper(impl)
}
