package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.{
  ClientToken,
  CertificateAuthorityBody
}
import scala.jdk.CollectionConverters.*
final case class CreateTrustStoreRequest(
    certificateList: Iterable[CertificateAuthorityBody],
    clientToken: Option[ClientToken] = None,
    tags: Option[Iterable[zio.aws.workspacesweb.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest = {
    import CreateTrustStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest
      .builder()
      .certificateList(certificateList.map { item =>
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(item.toArray[Byte])
      }.asJavaCollection)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.CreateTrustStoreRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreateTrustStoreRequest.wrap(buildAwsValue())
}
object CreateTrustStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateTrustStoreRequest =
      zio.aws.workspacesweb.model.CreateTrustStoreRequest(
        certificateList,
        clientToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateList: List[CertificateAuthorityBody]
    def clientToken: Option[ClientToken]
    def tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]]
    def getCertificateList: ZIO[Any, Nothing, List[CertificateAuthorityBody]] =
      ZIO.succeed(certificateList)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest
  ) extends zio.aws.workspacesweb.model.CreateTrustStoreRequest.ReadOnly {
    override val certificateList: List[CertificateAuthorityBody] = impl
      .certificateList()
      .asScala
      .map { item =>
        zio.aws.workspacesweb.model.primitives.CertificateAuthorityBody(
          zio.Chunk.fromArray(item.asByteArrayUnsafe())
        )
      }
      .toList
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val tags: Option[List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest
  ): zio.aws.workspacesweb.model.CreateTrustStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
