package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workspacesweb.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListBrowserSettingsResponse(
    browserSettings: Option[
      Iterable[zio.aws.workspacesweb.model.BrowserSettingsSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse = {
    import ListBrowserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
      .builder()
      .optionallyWith(
        browserSettings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.browserSettings)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.ListBrowserSettingsResponse
      .wrap(buildAwsValue())
}
object ListBrowserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.ListBrowserSettingsResponse =
      zio.aws.workspacesweb.model.ListBrowserSettingsResponse(
        browserSettings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def browserSettings: Option[
      List[zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly]
    ]
    def nextToken: Option[PaginationToken]
    def getBrowserSettings: ZIO[Any, AwsError, List[
      zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("browserSettings", browserSettings)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
  ) extends zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly {
    override val browserSettings: Option[
      List[zio.aws.workspacesweb.model.BrowserSettingsSummary.ReadOnly]
    ] = scala
      .Option(impl.browserSettings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workspacesweb.model.BrowserSettingsSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse
  ): zio.aws.workspacesweb.model.ListBrowserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
