package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBrowserSettingsResponse(
    browserSettings: Option[zio.aws.workspacesweb.model.BrowserSettings] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse = {
    import GetBrowserSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse
      .builder()
      .optionallyWith(browserSettings.map(value => value.buildAwsValue()))(
        _.browserSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetBrowserSettingsResponse.wrap(buildAwsValue())
}
object GetBrowserSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetBrowserSettingsResponse =
      zio.aws.workspacesweb.model.GetBrowserSettingsResponse(
        browserSettings.map(value => value.asEditable)
      )
    def browserSettings
        : Option[zio.aws.workspacesweb.model.BrowserSettings.ReadOnly]
    def getBrowserSettings: ZIO[
      Any,
      AwsError,
      zio.aws.workspacesweb.model.BrowserSettings.ReadOnly
    ] = AwsError.unwrapOptionField("browserSettings", browserSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse
  ) extends zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly {
    override val browserSettings
        : Option[zio.aws.workspacesweb.model.BrowserSettings.ReadOnly] = scala
      .Option(impl.browserSettings())
      .map(value => zio.aws.workspacesweb.model.BrowserSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse
  ): zio.aws.workspacesweb.model.GetBrowserSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
