package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetIdentityProviderResponse(
    identityProvider: Option[zio.aws.workspacesweb.model.IdentityProvider] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse = {
    import GetIdentityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse
      .builder()
      .optionallyWith(identityProvider.map(value => value.buildAwsValue()))(
        _.identityProvider
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly =
    zio.aws.workspacesweb.model.GetIdentityProviderResponse
      .wrap(buildAwsValue())
}
object GetIdentityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.GetIdentityProviderResponse =
      zio.aws.workspacesweb.model.GetIdentityProviderResponse(
        identityProvider.map(value => value.asEditable)
      )
    def identityProvider
        : Option[zio.aws.workspacesweb.model.IdentityProvider.ReadOnly]
    def getIdentityProvider: ZIO[
      Any,
      AwsError,
      zio.aws.workspacesweb.model.IdentityProvider.ReadOnly
    ] = AwsError.unwrapOptionField("identityProvider", identityProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse
  ) extends zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly {
    override val identityProvider
        : Option[zio.aws.workspacesweb.model.IdentityProvider.ReadOnly] = scala
      .Option(impl.identityProvider())
      .map(value => zio.aws.workspacesweb.model.IdentityProvider.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse
  ): zio.aws.workspacesweb.model.GetIdentityProviderResponse.ReadOnly =
    new Wrapper(impl)
}
