package zio.aws.workspacesweb
import zio.aws.workspacesweb.model.primitives.BrowserPolicy.Type
import zio.aws.workspacesweb.model.primitives.{
  SubnetId,
  SecurityGroupId,
  CertificateAuthorityBody,
  CertificateThumbprint,
  ARN,
  StringType,
  TagKey
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.workspacesweb.model.primitives.ARN.Type
    object BrowserPolicy extends Subtype[String]
    type BrowserPolicy =
      zio.aws.workspacesweb.model.primitives.BrowserPolicy.Type
    object CertificateAuthorityBody extends Subtype[Chunk[Byte]]
    type CertificateAuthorityBody =
      zio.aws.workspacesweb.model.primitives.CertificateAuthorityBody.Type
    object CertificatePrincipal extends Subtype[String]
    type CertificatePrincipal =
      zio.aws.workspacesweb.model.primitives.CertificatePrincipal.Type
    object CertificateThumbprint extends Subtype[String]
    type CertificateThumbprint =
      zio.aws.workspacesweb.model.primitives.CertificateThumbprint.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.workspacesweb.model.primitives.ClientToken.Type
    object CookieDomain extends Subtype[String]
    type CookieDomain = zio.aws.workspacesweb.model.primitives.CookieDomain.Type
    object CookieName extends Subtype[String]
    type CookieName = zio.aws.workspacesweb.model.primitives.CookieName.Type
    object CookiePath extends Subtype[String]
    type CookiePath = zio.aws.workspacesweb.model.primitives.CookiePath.Type
    object Description extends Subtype[String]
    type Description = zio.aws.workspacesweb.model.primitives.Description.Type
    object DisconnectTimeoutInMinutes extends Subtype[Int]
    type DisconnectTimeoutInMinutes =
      zio.aws.workspacesweb.model.primitives.DisconnectTimeoutInMinutes.Type
    object DisplayName extends Subtype[String]
    type DisplayName = zio.aws.workspacesweb.model.primitives.DisplayName.Type
    object IdentityProviderName extends Subtype[String]
    type IdentityProviderName =
      zio.aws.workspacesweb.model.primitives.IdentityProviderName.Type
    object IdleDisconnectTimeoutInMinutes extends Subtype[Int]
    type IdleDisconnectTimeoutInMinutes =
      zio.aws.workspacesweb.model.primitives.IdleDisconnectTimeoutInMinutes.Type
    object IpRange extends Subtype[String]
    type IpRange = zio.aws.workspacesweb.model.primitives.IpRange.Type
    object KeyArn extends Subtype[String]
    type KeyArn = zio.aws.workspacesweb.model.primitives.KeyArn.Type
    object KinesisStreamArn extends Subtype[String]
    type KinesisStreamArn =
      zio.aws.workspacesweb.model.primitives.KinesisStreamArn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.workspacesweb.model.primitives.MaxResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.workspacesweb.model.primitives.PaginationToken.Type
    object PortalEndpoint extends Subtype[String]
    type PortalEndpoint =
      zio.aws.workspacesweb.model.primitives.PortalEndpoint.Type
    object SamlMetadata extends Subtype[String]
    type SamlMetadata = zio.aws.workspacesweb.model.primitives.SamlMetadata.Type
    object SecurityGroupId extends Subtype[String]
    type SecurityGroupId =
      zio.aws.workspacesweb.model.primitives.SecurityGroupId.Type
    object StatusReason extends Subtype[String]
    type StatusReason = zio.aws.workspacesweb.model.primitives.StatusReason.Type
    type StringType = String
    object SubnetId extends Subtype[String]
    type SubnetId = zio.aws.workspacesweb.model.primitives.SubnetId.Type
    object SubresourceARN extends Subtype[String]
    type SubresourceARN =
      zio.aws.workspacesweb.model.primitives.SubresourceARN.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.workspacesweb.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.workspacesweb.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.workspacesweb.model.primitives.Timestamp.Type
    object VpcId extends Subtype[String]
    type VpcId = zio.aws.workspacesweb.model.primitives.VpcId.Type
  }
  type ArnList = List[ARN]
  type BrowserSettingsList =
    List[zio.aws.workspacesweb.model.BrowserSettingsSummary]
  type CertificateList = List[CertificateAuthorityBody]
  type CertificateSummaryList =
    List[zio.aws.workspacesweb.model.CertificateSummary]
  type CertificateThumbprintList = List[CertificateThumbprint]
  type CookieSpecifications =
    List[zio.aws.workspacesweb.model.CookieSpecification]
  type EncryptionContextMap = Map[StringType, StringType]
  type IdentityProviderDetails = Map[StringType, StringType]
  type IdentityProviderList =
    List[zio.aws.workspacesweb.model.IdentityProviderSummary]
  type IpAccessSettingsList =
    List[zio.aws.workspacesweb.model.IpAccessSettingsSummary]
  type IpRuleList = List[zio.aws.workspacesweb.model.IpRule]
  type NetworkSettingsList =
    List[zio.aws.workspacesweb.model.NetworkSettingsSummary]
  type PortalList = List[zio.aws.workspacesweb.model.PortalSummary]
  type SecurityGroupIdList = List[SecurityGroupId]
  type SubnetIdList = List[SubnetId]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.workspacesweb.model.Tag]
  type TrustStoreSummaryList =
    List[zio.aws.workspacesweb.model.TrustStoreSummary]
  type UserAccessLoggingSettingsList =
    List[zio.aws.workspacesweb.model.UserAccessLoggingSettingsSummary]
  type UserSettingsList = List[zio.aws.workspacesweb.model.UserSettingsSummary]
}
