package zio.aws.workspacesweb.model
import zio.aws.workspacesweb.model.primitives.{
  IdleDisconnectTimeoutInMinutes,
  KeyArn,
  ClientToken,
  DisconnectTimeoutInMinutes,
  StringType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateUserSettingsRequest(
    additionalEncryptionContext: Optional[Map[StringType, StringType]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    cookieSynchronizationConfiguration: Optional[
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration
    ] = Optional.Absent,
    copyAllowed: zio.aws.workspacesweb.model.EnabledType,
    customerManagedKey: Optional[KeyArn] = Optional.Absent,
    disconnectTimeoutInMinutes: Optional[DisconnectTimeoutInMinutes] =
      Optional.Absent,
    downloadAllowed: zio.aws.workspacesweb.model.EnabledType,
    idleDisconnectTimeoutInMinutes: Optional[IdleDisconnectTimeoutInMinutes] =
      Optional.Absent,
    pasteAllowed: zio.aws.workspacesweb.model.EnabledType,
    printAllowed: zio.aws.workspacesweb.model.EnabledType,
    tags: Optional[Iterable[zio.aws.workspacesweb.model.Tag]] = Optional.Absent,
    uploadAllowed: zio.aws.workspacesweb.model.EnabledType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest = {
    import CreateUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
      .builder()
      .optionallyWith(
        additionalEncryptionContext.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.additionalEncryptionContext)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        cookieSynchronizationConfiguration.map(value => value.buildAwsValue())
      )(_.cookieSynchronizationConfiguration)
      .copyAllowed(copyAllowed.unwrap)
      .optionallyWith(
        customerManagedKey.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.customerManagedKey)
      .optionallyWith(
        disconnectTimeoutInMinutes.map(value =>
          DisconnectTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.disconnectTimeoutInMinutes)
      .downloadAllowed(downloadAllowed.unwrap)
      .optionallyWith(
        idleDisconnectTimeoutInMinutes.map(value =>
          IdleDisconnectTimeoutInMinutes.unwrap(value): Integer
        )
      )(_.idleDisconnectTimeoutInMinutes)
      .pasteAllowed(pasteAllowed.unwrap)
      .printAllowed(printAllowed.unwrap)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .uploadAllowed(uploadAllowed.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateUserSettingsRequest.ReadOnly =
    zio.aws.workspacesweb.model.CreateUserSettingsRequest.wrap(buildAwsValue())
}
object CreateUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateUserSettingsRequest =
      zio.aws.workspacesweb.model.CreateUserSettingsRequest(
        additionalEncryptionContext.map(value => value),
        clientToken.map(value => value),
        cookieSynchronizationConfiguration.map(value => value.asEditable),
        copyAllowed,
        customerManagedKey.map(value => value),
        disconnectTimeoutInMinutes.map(value => value),
        downloadAllowed,
        idleDisconnectTimeoutInMinutes.map(value => value),
        pasteAllowed,
        printAllowed,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        uploadAllowed
      )
    def additionalEncryptionContext: Optional[Map[StringType, StringType]]
    def clientToken: Optional[ClientToken]
    def cookieSynchronizationConfiguration: Optional[
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly
    ]
    def copyAllowed: zio.aws.workspacesweb.model.EnabledType
    def customerManagedKey: Optional[KeyArn]
    def disconnectTimeoutInMinutes: Optional[DisconnectTimeoutInMinutes]
    def downloadAllowed: zio.aws.workspacesweb.model.EnabledType
    def idleDisconnectTimeoutInMinutes: Optional[IdleDisconnectTimeoutInMinutes]
    def pasteAllowed: zio.aws.workspacesweb.model.EnabledType
    def printAllowed: zio.aws.workspacesweb.model.EnabledType
    def tags: Optional[List[zio.aws.workspacesweb.model.Tag.ReadOnly]]
    def uploadAllowed: zio.aws.workspacesweb.model.EnabledType
    def getAdditionalEncryptionContext
        : ZIO[Any, AwsError, Map[StringType, StringType]] =
      AwsError.unwrapOptionField(
        "additionalEncryptionContext",
        additionalEncryptionContext
      )
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCookieSynchronizationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cookieSynchronizationConfiguration",
      cookieSynchronizationConfiguration
    )
    def getCopyAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(copyAllowed)
    def getCustomerManagedKey: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("customerManagedKey", customerManagedKey)
    def getDisconnectTimeoutInMinutes
        : ZIO[Any, AwsError, DisconnectTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "disconnectTimeoutInMinutes",
        disconnectTimeoutInMinutes
      )
    def getDownloadAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(downloadAllowed)
    def getIdleDisconnectTimeoutInMinutes
        : ZIO[Any, AwsError, IdleDisconnectTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "idleDisconnectTimeoutInMinutes",
        idleDisconnectTimeoutInMinutes
      )
    def getPasteAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(pasteAllowed)
    def getPrintAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(printAllowed)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUploadAllowed
        : ZIO[Any, Nothing, zio.aws.workspacesweb.model.EnabledType] =
      ZIO.succeed(uploadAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
  ) extends zio.aws.workspacesweb.model.CreateUserSettingsRequest.ReadOnly {
    override val additionalEncryptionContext
        : Optional[Map[StringType, StringType]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalEncryptionContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: StringType) -> (value: StringType)
          })
          .toMap
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.workspacesweb.model.primitives.ClientToken(value))
    override val cookieSynchronizationConfiguration: Optional[
      zio.aws.workspacesweb.model.CookieSynchronizationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cookieSynchronizationConfiguration())
      .map(value =>
        zio.aws.workspacesweb.model.CookieSynchronizationConfiguration
          .wrap(value)
      )
    override val copyAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.copyAllowed())
    override val customerManagedKey: Optional[KeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManagedKey())
      .map(value => zio.aws.workspacesweb.model.primitives.KeyArn(value))
    override val disconnectTimeoutInMinutes
        : Optional[DisconnectTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.disconnectTimeoutInMinutes())
      .map(value =>
        zio.aws.workspacesweb.model.primitives.DisconnectTimeoutInMinutes(value)
      )
    override val downloadAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.downloadAllowed())
    override val idleDisconnectTimeoutInMinutes
        : Optional[IdleDisconnectTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.idleDisconnectTimeoutInMinutes())
      .map(value =>
        zio.aws.workspacesweb.model.primitives
          .IdleDisconnectTimeoutInMinutes(value)
      )
    override val pasteAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.pasteAllowed())
    override val printAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.printAllowed())
    override val tags
        : Optional[List[zio.aws.workspacesweb.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workspacesweb.model.Tag.wrap(item)
          }.toList
        )
    override val uploadAllowed: zio.aws.workspacesweb.model.EnabledType =
      zio.aws.workspacesweb.model.EnabledType.wrap(impl.uploadAllowed())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest
  ): zio.aws.workspacesweb.model.CreateUserSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
