package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workspacesweb.model.primitives.SubresourceARN
import scala.jdk.CollectionConverters._
final case class CreateIdentityProviderResponse(
    identityProviderArn: SubresourceARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse = {
    import CreateIdentityProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
      .builder()
      .identityProviderArn(
        SubresourceARN.unwrap(identityProviderArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly =
    zio.aws.workspacesweb.model.CreateIdentityProviderResponse
      .wrap(buildAwsValue())
}
object CreateIdentityProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.CreateIdentityProviderResponse =
      zio.aws.workspacesweb.model
        .CreateIdentityProviderResponse(identityProviderArn)
    def identityProviderArn: SubresourceARN
    def getIdentityProviderArn: ZIO[Any, Nothing, SubresourceARN] =
      ZIO.succeed(identityProviderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
  ) extends zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly {
    override val identityProviderArn: SubresourceARN =
      zio.aws.workspacesweb.model.primitives
        .SubresourceARN(impl.identityProviderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse
  ): zio.aws.workspacesweb.model.CreateIdentityProviderResponse.ReadOnly =
    new Wrapper(impl)
}
