package zio.aws.workspacesweb.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workspacesweb.model.primitives.{VpcId, ARN}
import scala.jdk.CollectionConverters._
final case class NetworkSettingsSummary(
    networkSettingsArn: ARN,
    vpcId: Optional[VpcId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary = {
    import NetworkSettingsSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
      .builder()
      .networkSettingsArn(ARN.unwrap(networkSettingsArn): java.lang.String)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly =
    zio.aws.workspacesweb.model.NetworkSettingsSummary.wrap(buildAwsValue())
}
object NetworkSettingsSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workspacesweb.model.NetworkSettingsSummary =
      zio.aws.workspacesweb.model
        .NetworkSettingsSummary(networkSettingsArn, vpcId.map(value => value))
    def networkSettingsArn: ARN
    def vpcId: Optional[VpcId]
    def getNetworkSettingsArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(networkSettingsArn)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
  ) extends zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly {
    override val networkSettingsArn: ARN =
      zio.aws.workspacesweb.model.primitives.ARN(impl.networkSettingsArn())
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.workspacesweb.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary
  ): zio.aws.workspacesweb.model.NetworkSettingsSummary.ReadOnly = new Wrapper(
    impl
  )
}
